using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Presenter;
using System;
using System.Collections.Generic;
using System.IO;
using System.Threading;
using inetsoftware.Pdfc.Error;
using inetsoftware.Pdfc.Results;

namespace inetsoftware.PdfcSamples
{

    /// <summary>
    /// A simple sample for batch compare (compare with to folder, wither files with the same name)
    /// </summary>
    public class BatchCompare
    {
        static BatchCompare()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, that show how compare two folders.
        /// First argument is the folder for the result output
        /// Second/Thrird argument are the folders with the compare documents. (In Both folder should documents exist
        /// with the same name. Only the files with the same name are compared with each other
        /// </summary>
        /// <param name="args">Expects 3 arguments: the paths of the 2 PDF files that will be compared.</param>
        public static void Main(string[] args)
        {
            var usageText = "Usage: <executable> <Result Folder> <Folder 1 with PDF Files> <Folder 2 with PDF Files>";
            if (args == null || args.Length != 3)
            {
                throw new ArgumentException(usageText);
            }

            foreach (string arg in args)
            {
                if(!Directory.Exists(arg)){
                    throw new ArgumentException("The argument is not a folder. " + arg + "\n" +usageText);
                }
            }

            DateTime start = DateTime.Now;
            //Start all comparison and store it in a map

            var storedResult = new Dictionary<String, ResultModel>();
            var storedPresenterExceptions = new Dictionary<String, PDFComparer>();
            foreach(string file1 in Directory.GetFiles(args[1]))
            {
                foreach(string file2 in Directory.GetFiles(args[2]))
                {
                    if(Path.GetFileName(file1).Equals(Path.GetFileName(file2))){
                        var presenter1 = new ReportPDFPresenter(true, true, "pdf", args[0], true);
                        var presenter2 = new DifferencesPDFPresenter(args[0], true );
                        var pdfComparer = new PDFComparer().AddPresenter(presenter1).AddPresenter(presenter2);
                        //The methode compare is async, when for example the ResultModel is accessed, it waits until the
                        //comparison is finished
                        ResultModel resultModel = pdfComparer.Compare(file1, file2);
                        Console.WriteLine("Comparison " + file1 + " vs " + file2 + " was started");
                        storedResult.Add(file1 + file2,resultModel );
                        storedPresenterExceptions.Add(file1 + file2,pdfComparer );
                    }
                }
            }
            Console.WriteLine("Evalutation steps...");
            List<Thread> parts = new List<Thread>();
            //All comparisons have been started now we can start the evaluation.
            foreach (var pair in storedResult)
            {
                String id = pair.Key;
                ResultModel resultModel = storedResult[id];
                //waits until the comparison is finished
                PresenterExceptionData[] presenterExceptionDatas = storedPresenterExceptions[id].GetPresenterExceptions();
                Console.WriteLine( "Comparison " + resultModel.GetComparisonParameters().FirstFile + " with " + resultModel.GetComparisonParameters().SecondFile + " has " + resultModel.GetDifferencesCount(false) + " differences");
                foreach (var presenterExceptionData in presenterExceptionDatas)
                {
                    Console.WriteLine("presenter occured an error " + presenterExceptionData.GetMessage);
                }
            }

            Console.WriteLine("Time used " + (DateTime.Now - start));
        }
    }
}
